<?php
header('Content-Type: application/json');
$config = require 'config.php';

echo json_encode([
    'paypal_email'   => $config['paypal_use_sandbox']
                        ? $config['paypal_sandbox_email']
                        : $config['paypal_live_email'],
    
    'paypal_url'     => $config['paypal_use_sandbox']
                        ? 'https://www.sandbox.paypal.com/cgi-bin/webscr'
                        : 'https://www.paypal.com/cgi-bin/webscr',

    'usdt_wallet'    => $config['usdt_wallet'],
    'rates'          => $config['rates'],
    'discounts'      => $config['discounts'],
    'stripe_success' => $config['success_url'],
    'stripe_cancel'  => $config['cancel_url'],
    'server_files'   => $config['ServerFiles'],
    'season'         => $config['Season'],
	'mutex_name'     => $config['mutex_name'],
	'admincp_passwords' => $config['admincp_passwords'],
	'custom_title_keywords' => $config['custom_title_keywords'],
    'nick_patterns'  => $config['nick_patterns'] ?? [],
    'level_patterns' => $config['level_patterns'] ?? [],
    'launcher_menu'  => $config['launcher_menu'] ?? [
        'home'     => true,
        'rankings' => true,
        'donate'   => true,
        'guides'   => true,
        'events'   => true
    ]
]);